% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Small.R
\name{findMotifRegion}
\alias{findMotifRegion}
\title{Use Hocomoco motif and homer to identify motifs in a given region}
\usage{
findMotifRegion(
  regions,
  output.filename = "mapped_motifs_regions.txt",
  region.size = NULL,
  genome = "hg38",
  nstep = 10000,
  cores = 1
)
}
\arguments{
\item{regions}{A GRanges object. Names will be used as the identifier.}

\item{output.filename}{Final file name}

\item{region.size}{If NULL the motif will be mapped to the region. If set a window around its center will be considered.
For example if region.size is 500, then +-250bp round it will be searched.}

\item{genome}{Homer genome (hg38, hg19)}

\item{nstep}{Number of regions to evaluate in homer, the bigger, more memory it will use at each step.}

\item{cores}{A interger which defines the number of cores to be used in parallel 
process. Default is 1: no parallel process.}
}
\description{
To find for each probe the know motif we will use HOMER software (http://homer.salk.edu/homer/).
Homer and genome should be installed before this function is executed
Step:
1 - get DNA methylation probes annotation with the regions
2 - Make a bed file from it
3 - Execute section: Finding Instance of Specific Motifs 
from http://homer.salk.edu/homer/ngs/peakMotifs.html to the HOCOMOCO TF motifs
Also, As HOMER is using more RAM than the available we will split the files in to 100k probes.
Obs: for each probe we create a winddow of 500 bp (-size 500) around it. 
This might lead to false positives, but will not have false negatives.
The false posives will be removed latter with some statistical tests.
}
\examples{
\dontrun{
 # use the center of the region and +-250bp around it
 gr0 <- GRanges(Rle(c("chr2", "chr2", "chr1", "chr3"), 
                    c(1, 3, 2, 4)
                    ), 
               IRanges(1:10, width=10:1)
               )
 names(gr0) <- paste0("ID",c(1:10))
 findMotifRegion(regions = gr0, region.size = 500, genome = "hg38", cores = 1)
 
 # use the region size itself
 gr1 <- GRanges(Rle(c("chr2", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)), 
                IRanges(1:10, width=sample(200:1000,10)))
 names(gr1) <- paste0("ID",c(1:10))
 findMotifRegion(regions = gr0, genome = "hg38", cores = 1)
}
}
