% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{createBigWigDNAmetArray}
\alias{createBigWigDNAmetArray}
\title{Create a bigwig file for IGV visualization of DNA methylation data (Array)}
\usage{
createBigWigDNAmetArray(
  data = NULL,
  genome = "hg38",
  met.platform = "450K",
  track.names = NULL,
  dir = "IGV_tracks"
)
}
\arguments{
\item{data}{A matrix}

\item{genome}{Which genome build will be used: hg38 (default) or hg19.}

\item{met.platform}{DNA methyaltion platform to retrieve data from: EPIC or 450K (default)}

\item{track.names}{Provide a  list of track names (.bw) otherwise the deault is the will be {samples}.bw}

\item{dir}{Which directory files will be saved}
}
\description{
Create a bigwig for IGV visualization of DNA methylation data (Array)
}
\examples{
 \dontrun{            
 data <- assay(getMet(ELMER:::getdata("elmer.data.example")))
 createBigWigDNAmetArray(data = data, met.platform = "450K", genome = "hg38")
 }
}
\author{
Tiago Chedraoui Silva (tiagochst at gmail.com)
}
