% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_pipe.R
\name{TCGA.pipe}
\alias{TCGA.pipe}
\title{ELMER analysis pipeline for TCGA data.}
\usage{
TCGA.pipe(
  disease,
  genome = "hg38",
  analysis = "all",
  wd = getwd(),
  cores = 1,
  mode = "unsupervised",
  Data = NULL,
  diff.dir = "hypo",
  genes = NULL,
  mutant_variant_classification = c("Frame_Shift_Del", "Frame_Shift_Ins",
    "Missense_Mutation", "Nonsense_Mutation", "Splice_Site", "In_Frame_Del",
    "In_Frame_Ins", "Translation_Start_Site", "Nonstop_Mutation"),
  group.col = "TN",
  group1 = "Tumor",
  group2 = "Normal",
  ...
)
}
\arguments{
\item{disease}{TCGA short form disease name such as COAD}

\item{genome}{Data aligned against which genome of reference. Options: "hg19", "hg38" (default)}

\item{analysis}{A vector of characters listing the analysis need to be done.
Analysis can be "download","distal.probes","diffMeth","pair","motif","TF.search".
Default is "all" meaning all the analysis will be processed.}

\item{wd}{A path shows working dirctory. Default is "./"}

\item{cores}{A interger which defines number of core to be used in parallel process. 
Default is 1: don't use parallel process.}

\item{mode}{This option will automatically set the percentage of samples to be used in the analysis.
Options: "supervised" (use 100\% of samples) or "unsupervised" (use 20\% of samples).}

\item{Data}{A path shows the folder containing DNA methylation, expression and clinic data}

\item{diff.dir}{A character can be "hypo" or "hyper", showing dirction DNA methylation changes.
If it is "hypo", get.diff.meth function will identify all significantly hypomethylated
CpG sites; If "hyper", get.diff.meth function will identify all significantly hypermethylated
CpG sites}

\item{genes}{List of genes for which mutations will be verified. 
A column in the MAE with the name of the gene
will be created with two groups WT (tumor samples without mutation), MUT (tumor samples w/ mutation), 
NA (not tumor samples)}

\item{mutant_variant_classification}{List of TCGA variant classification from MAF files to consider a samples
mutant. Only used when argument gene is set.}

\item{group.col}{A column defining the groups of the sample. You can view the 
available columns using: colnames(MultiAssayExperiment::colData(data)).}

\item{group1}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{group2}{A group from group.col. ELMER will run group1 vs group2. 
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{...}{A list of parameters for functions: GetNearGenes, get.feature.probe, 
get.diff.meth, get.pair}
}
\value{
Different analysis results.
}
\description{
ELMER analysis pipeline for TCGA data. This pipeline combine every steps of \pkg{ELMER}
analyses: get.feature.probe, get.diff.meth, get.pair, get.permu, get.enriched.motif and get.TFs.
Every steps' results are saved.
}
\examples{
  data <- ELMER:::getdata("elmer.data.example")
  TCGA.pipe(
    disease = "LUSC",
    data = data,
    analysis = c("diffMeth","pair", "motif","TF.search"), 
    mode = "supervised",
    group.col = "definition",
    group1 = "Primary solid Tumor", 
    group2 = "Solid Tissue Normal",
    diff.dir = c("hypo"),
    dir.out = "pipe",
    sig.dif = 0.0001,
    pvalue = 1.0,
    min.incidence = 0,
    lower.OR = 0.0
  )
\dontrun{
  distal.probe <- TCGA.pipe(disease = "LUSC", analysis="distal.enhancer", wd="~/")
  TCGA.pipe(disease = "LUSC",analysis = "all", genome = "hg19", cores = 1, permu.size=300, Pe=0.01)
  projects <- TCGAbiolinks:::getGDCprojects()$project_id
  projects <- gsub("TCGA-","",projects[grepl('^TCGA',projects,perl=TRUE)])
  for(proj in projects) TCGA.pipe(disease = proj,analysis = "download")
  plyr::alply(sort(projects),1,function(proj) {
       tryCatch({
         print(proj);
         TCGA.pipe(disease = proj,analysis = c("createMAE"))})
       }, .progress = "text")
  plyr::alply(sort(projects),1,function(proj) {
    tryCatch({
      print(proj);
      TCGA.pipe(disease = proj,
                 analysis = c("diffMeth","pair", "motif","TF.search"))})
  }, .progress = "text")

  # Evaluation mutation
  TCGA.pipe(disease = "LUSC",analysis = "createMAE",gene = "NFE2L2")
  TCGA.pipe(
     disease = "LUSC",analysis = c("diffMeth","pair", "motif","TF.search"), 
     mode = "supervised",
     group.col = "NFE2L2", group1 = "Mutant", group2 = "WT",
     diff.dir = c("hypo"),
     dir.out = "LUSC_NFE2L2_MutvsWT"
   )
}
}
