% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNearbyGenes.R
\name{GetNearGenes}
\alias{GetNearGenes}
\title{GetNearGenes to collect nearby genes for one locus.}
\usage{
GetNearGenes(
  data = NULL,
  probes = NULL,
  geneAnnot = NULL,
  TRange = NULL,
  numFlankingGenes = 20
)
}
\arguments{
\item{data}{A multi Assay Experiment with both DNA methylation and gene Expression objects}

\item{probes}{Name of probes to get nearby genes (it should be rownames of the DNA methylation 
object in the data argument object)}

\item{geneAnnot}{A GRange object  or Summarized Experiment object that contains coordinates of promoters for 
human genome.}

\item{TRange}{A GRange object or Summarized Experiment object that contains coordinates of a list of targets loci.}

\item{numFlankingGenes}{A number determines how many gene will be collected totally. 
Then the number devided by 2 is the number of genes collected from 
each side of targets (number shoule be even) Default to 20.}
}
\value{
A data frame of nearby genes and information: genes' IDs, genes' symbols, 
distance with target and side to which the gene locate to the target.
}
\description{
GetNearGenes is a function to collect equal number of gene on each side of one locus.
It can receite either multi Assay Experiment with both DNA methylation and gene Expression matrix
and the names of probes to select nearby genes, or it can receive two granges objects TRange and geneAnnot.
}
\examples{
geneAnnot <- getTSS(genome = "hg38")
probe <- GenomicRanges::GRanges(seqnames = c("chr1","chr2"), 
range=IRanges::IRanges(start = c(16058489,236417627), end= c(16058489,236417627)), 
name= c("cg18108049","cg17125141"))
names(probe) <- c("cg18108049","cg17125141")
NearbyGenes <- GetNearGenes(numFlankingGenes = 20,geneAnnot=geneAnnot,TRange=probe)
}
\references{
Yao, Lijing, et al. "Inferring regulatory element landscapes and transcription 
factor networks from cancer methylomes." Genome biology 16.1 (2015): 1.
}
