% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_densities.R
\name{plot_densities}
\alias{plot_densities}
\title{Plot densities}
\usage{
plot_densities(
  hists,
  id,
  col = c("lightgrey"),
  xlab = "",
  ylab = "Density",
  mode = "hist"
)
}
\arguments{
\item{hists}{list of histogram objects or density objects}

\item{id}{string}

\item{col}{color for shading}

\item{xlab}{string x-axis label}

\item{ylab}{string y-axis label}

\item{mode}{flag indicating histogram or density}
}
\value{
null
}
\description{
The function plots multiple density curves and compares their modes
}
\examples{
aurocsA <- density((runif(1000)+runif(1000)+runif(1000)+runif(1000))/4)
aurocsB <- density((runif(1000)+runif(1000)+runif(1000))/3)
aurocsC <- density(runif(1000))
hists <- list(aurocsA, aurocsB, aurocsC)
temp <- plot_densities(hists,'', mode='density')

}
\keyword{density}
\keyword{plot}
