% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_comparisons.R
\name{compareMultipleInteractions}
\alias{compareMultipleInteractions}
\title{Compare multiple RNA-RNA interactions sets}
\usage{
compareMultipleInteractions(
  gi_samples_list,
  min_ratio = 0.3,
  minoverlap = 5,
  maxgap = 50,
  niter = 3,
  gi_superset = NULL,
  anno_gr = NULL
)
}
\arguments{
\item{gi_samples_list}{anmes list with the \code{GInteractions} entries list('sample1'=gi1,'sample2'='gi2)}

\item{min_ratio}{If the overlap-to-span ratio for either arm (A or B) for pair
of chimeric reads is less than \code{min_arm_ratio}, then the total overlap for this pair is set to zero.
Relevant to comparison of superset vs individual samples}

\item{minoverlap}{Parameter for read clustering to create a superset. Minimum required overlap to for either arm (A or B) for pair of entries.}

\item{maxgap}{Parameter for read clustering. Minimum required shift between start and end coordinates of arms for pair of overlapping entries..
If the shift is longer than \code{max_gap} for either arm, then total read overlap between those reads is zero.}

\item{niter}{Internal parameter for debugging. Number of cluster& collapse iterations to find superset}

\item{gi_superset}{Optional. Superset defining the space (all) of the interactions, against which inputs from the list will be compared.}

\item{anno_gr}{Optional. \code{Granges} to annotate superset.}
}
\value{
dataframe recodding the overlaps between samples and supeset
}
\description{
Combines all interaction into single superset by clustering & collapsing.
Then compares every input entry with the superset. Overlaps between superset and
inputs are recorded in a table as 0/1
}
\examples{
# Create test set of RNA interactions
chrom <- "chr1"
start1 <- c(1, 11, 21, 31, 41, 51, 61, 71, 81, 91)
end1 <- start1 + 9
start2 <- c(101, 111, 121, 131, 141, 151, 161, 171, 181, 191)
end2 <- start2 + 9

anchor1 <- GRanges(seqnames = chrom, ranges = IRanges(start = start1, end = end1))
anchor2 <- GRanges(seqnames = chrom, ranges = IRanges(start = start2, end = end2))

interaction <- GInteractions(anchor1, anchor2)

# Ensure some overlaps
n <- length(interaction)
group_size <- ceiling(n / 2)
group_indices1 <- sort(sample(seq_len(n), group_size))
group_indices2 <- sort(sample(seq_len(n), group_size))
group_indices3 <- sort(sample(seq_len(n), group_size))

# Create separate GInteractions objects for each group
group1 <- interaction[group_indices1]
group2 <- interaction[group_indices2]
group3 <- interaction[group_indices3]

# format input and call comparison
a <- list("sample1" = group1, "sample2" = group2, "sample3" = group3)
res <- compareMultipleInteractions(a)
# comparison result
head(res$dt_upset)
# superset
res$gi_all
# dataframe for the Upset plot
res$dt_upset
}
