% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{RNADuplexSampleGI}
\alias{RNADuplexSampleGI}
\title{RNA duplex reads of SPLASH derived from chimeric alignments}
\format{
An object of class \code{StrictGInteractions} of length 2090.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR3404943}{SequenceReadArcive}
}
\usage{
data(RNADuplexesSampleData)
}
\value{
\code{GInteractions} with
\itemize{
\item \code{readname} : read name
\item \code{map_type } : type of the mapped read (2arm by design of pre-filtering)
\item \code{junction_type} : if read jucntion is too short, or it not a 'true' ligated
reads because of the jucntoin coincides with splice junction
\item cigar_aln* columns inherited from the STAR Chimeric.out.Junction output
}
}
\description{
\code{GInteractions} read-level object containing two-arm chimeric reads extracted from
mapping output and which can be represented in the \code{GInteraction} object
}
\details{
see \code{system.file("extdata/scripts", "DD_data_generation.R", package =
"DuplexDiscovereR")} for details on the data generation proccedure.
}
\keyword{datasets}
