% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNMIs}
\alias{plotNMIs}
\title{Plot an heatmap of the NMI matrix}
\usage{
plotNMIs(clusMat, unclustered = NULL, values = TRUE, numericalLabels = FALSE)
}
\arguments{
\item{clusMat}{The clustering matrix with a row per cell and a column per
clustering label type}

\item{unclustered}{The value assigned to unclustered cells. Default to \code{NULL}}

\item{values}{Whether to also display the ARI values. Default to TRUE.}

\item{numericalLabels}{Whether labels are numerical values. Default to FALSE.}
}
\value{
a \code{\link{ggplot}} object
}
\description{
We can compute the NMI between pairs of cluster labels. This function plots
a matrix where a cell is the Normalized Mutual Information between cluster label of
row i and cluster label of column j.
}
\examples{
data("clusMat", package = "Dune")
merger <- Dune(clusMat = clusMat, metric = "NMI")
plotNMIs(merger$initialMat)
plotNMIs(merger$currentMat)
}
