% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_directory.R
\name{create_directory}
\alias{create_directory}
\title{Create a Directory and Optionally Set as Working Directory}
\usage{
create_directory(directory_path, set_working_dir = FALSE)
}
\arguments{
\item{directory_path}{A character string specifying the path of the directory to create.}

\item{set_working_dir}{A logical value indicating whether to set the directory as the working directory. Default is FALSE.}
}
\value{
NULL. The function prints messages indicating whether the directory was created or already exists, and if the working directory was set.
}
\description{
This function checks if a specified directory exists and creates it if it doesn't.
Optionally, it can also set the newly created or existing directory as the working directory.
}
\examples{
if (interactive()) {
  # Save the current working directory
  old_wd <- getwd()

  # Use a temporary directory for safe example use
  tmp_dir <- file.path(tempdir(), "example_new_dir")

  # Create the directory and set it as the working directory
  create_directory(tmp_dir, set_working_dir = TRUE)

  # Do something inside tmp_dir...

  # Restore the original working directory
  setwd(old_wd)

  # Remove the created directory
  unlink(tmp_dir, recursive = TRUE, force = TRUE)
}
}
