\name{resultSummary}
\alias{resultSummary}
\title{
Summarize result for drivers ranking.
}
\description{
Ranks the drivers.
}
\usage{
resultSummary(mainResult, randResult, patMutMatrix, influenceGraph, 
outputFolder = NULL, printToConsole = FALSE)
}
\arguments{
  \item{mainResult}{
An object of DriverNetResult class created by the computeDrivers method.
}
  \item{randResult}{
A list of vectors representing driver coverage generated by \code{computeRandomizedResult}.
}
  \item{patMutMatrix}{
Patient Mutation Matrix
}
  \item{influenceGraph}{
Influence Graph Matrix
}
  \item{outputFolder}{
The folder to store the summary file. If set to NULL, no files will be written. If set to "", the files will be written to the current folder.
}
  \item{printToConsole}{
If set to TRUE, progress and result of the function will be printed to the console.
}
}
\value{
A matrix storing the summary result.
}
\author{
Ali Bashashati, Reza Haffari, Jiarui Ding, Gavin Ha,  Kenneth Liu, Jamie Rosner and Sohrab Shah

Maintainer: Jiarui Ding <jiaruid@cs.ubc.ca>
}
\examples{
data(sampleDriversList)
data(sampleRandomDriversResult)
data(samplePatientMutationMatrix)
data(sampleInfluenceGraph)
%load(system.file("data", "sampleData.rda", package="DriverNet"))
res = resultSummary(sampleDriversList, sampleRandomDriversResult, 
samplePatientMutationMatrix, sampleInfluenceGraph, outputFolder=NULL, 
printToConsole=FALSE)
}
\keyword{ methods }
