% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseDistrs.R
\name{normalizedDifferenceOfProbabilities}
\alias{normalizedDifferenceOfProbabilities}
\title{normalized probability differences}
\usage{
normalizedDifferenceOfProbabilities(p1, p2)
}
\arguments{
\item{p1}{probability vector representing the first symbol distribution}

\item{p2}{probability vector representing the second symbol distribution}
}
\value{
a vector with one result for each symbol
}
\description{
probability differences normalized by the sum of absolute probability differences for the given pair of probability vectors
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}

pwm1 = motifs[[motif_names[[1]]]]
pwm2 = motifs[[motif_names[[2]]]]

diffLogoFromPwm(pwm1 = pwm1, pwm2 = pwm2, baseDistribution = normalizedDifferenceOfProbabilities)
}
\author{
Martin Nettling
}
