% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackHeights.R
\name{lossOfAbsICDifferences}
\alias{lossOfAbsICDifferences}
\title{the change of information content}
\usage{
lossOfAbsICDifferences(p1, p2)
}
\arguments{
\item{p1}{probability vector representing the first symbol distribution}

\item{p2}{probability vector representing the second symbol distribution}
}
\value{
an object consisting of height and ylab
}
\description{
the change of information content for the given probability vectors
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}

pwm1 = motifs[[motif_names[[1]]]]
pwm2 = motifs[[motif_names[[2]]]]

diffLogoFromPwm(pwm1 = pwm1, pwm2 = pwm2, stackHeight = lossOfAbsICDifferences)
}
\author{
Martin Nettling
}
