% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depInfeR.R
\name{processTarget}
\alias{processTarget}
\title{Function for pre-processing drug-protein affinity dataset}
\usage{
processTarget(
  targetsMat,
  KdAsInput = TRUE,
  removeCorrelated = TRUE,
  keepTargets = NULL,
  cutoff = 0.8
)
}
\arguments{
\item{targetsMat}{Drug-protein affinity matrix with kd values (or optionally 
other affinity measurement values at roughly normal distribution). Each row is
a drug and each column is a sample (cell line or tumor sample).}

\item{KdAsInput}{A boolean value indicating whether the drug-protein
affinity matrix contains kd values which should be log- and arctan-transformed.
The default value is TRUE.}

\item{removeCorrelated}{A boolean value indicating whether highly
correlated proteins should be summarized in target groups. 
The default value is TRUE.}

\item{keepTargets}{A character variable that specifies important proteins
that should be retained in the matrix.}

\item{cutoff}{A Cosine similarity cutoff value for clustering proteins 
into one target group. The value should be between 0 and 1.}
}
\value{
A list of two elements: 1)\code{targetMatrix} Pre-processed drug-protein
affinity matrix; 2)\code{targetCluster}, a list that contains the targets
show high correlations with each other.
}
\description{
This function is used to preprocess the drug-protein affinity dataset
including the following steps:
- log-transform kd values (KdAsInput = TRUE)
- arctan-transform log(kd) values (KdAsInput = TRUE)
- check target similarity and remove highly correlated proteins
(removeCorrelated = TRUE)
- specify targets that should be kept in the matrix (keepTargets = NULL)
}
\details{
All steps within this function are optional depending on input data.
The transformation steps should be performed
if the affinity matrix consists of kd values.
If there are highly correlated features within the affinity matrix,
they can be removed using the provided function.
}
\examples{
data(targetMatrix)
processTarget(targetsMat = targetMatrix, KdAsInput = TRUE , removeCorrelated = TRUE)

}
