% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm_model.R
\name{solve_poisson_mixture}
\alias{solve_poisson_mixture}
\title{Poisson mixture model solver}
\usage{
solve_poisson_mixture(
  x,
  s,
  max_iter = 5000,
  tol = 1e-06,
  pi_inits = runif(10, min = 0, max = 0.5),
  posterior_cutoff = 0.6,
  verbose = FALSE
)
}
\arguments{
\item{x}{A vector of counts.}

\item{s}{A vector of offsets.}

\item{max_iter}{Maximum number of iterations for the EM algorithm.}

\item{tol}{Tolerance for convergence.}

\item{pi_inits}{Initial values for the mixing proportion.}

\item{posterior_cutoff}{Cutoff for posterior probabilities to assign memberships.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\value{
{
A list containing the following elements:
\item{memberships}{A vector indicating the membership of each observation (0 or 1).}
\item{posterior}{A vector of posterior probabilities for each observation.}
\item{lambda1}{Estimated parameter for the first component.}
\item{lambda2}{Estimated parameter for the second component.}
\item{pi}{Estimated mixing proportion.}
\item{log_lik}{Log-likelihood of the fitted model.}
}
}
\description{
This function implements a 2-component Poisson mixture model
using the EM algorithm. It estimates the parameters of the model and assigns
memberships to each observation based on the posterior probabilities.
}
\details{
The function takes a vector of counts and a vector of offsets as input.
It uses the EM algorithm to iteratively update the parameters of the model
until convergence is reached or the maximum number of iterations is exceeded.
The function also allows for multiple initialisations of the mixing proportion
to find the best solution.
}
\examples{
x <- rpois(100, lambda = 5)
s <- runif(100, min = 0, max = 1)
result <- solve_poisson_mixture(x, s)
print(result)
}
