% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mean_ratio.R
\name{get_mean_ratio}
\alias{get_mean_ratio}
\title{Get Mean Ratio for Each Gene x Cell Type}
\usage{
get_mean_ratio(
  sce,
  cellType_col,
  assay_name = "logcounts",
  gene_ensembl = NULL,
  gene_name = NULL
)
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class}
(or any derivative class) object containing single cell/nucleus gene
expression data.}

\item{cellType_col}{A \code{character(1)} name of the column in the
\link[SummarizedExperiment:SummarizedExperiment-class]{colData()} of \code{sce} that
denotes the cell type or group of interest.}

\item{assay_name}{A \code{character(1)} specifying the name of the
\link[SummarizedExperiment:SummarizedExperiment-class]{assay()} in the
\code{sce} object to use to rank expression values. Defaults to \code{logcounts} since
it typically contains the normalized expression values.}

\item{gene_ensembl}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the ENSEMBL gene IDs. This will be used by \code{layer_stat_cor()}.}

\item{gene_name}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the gene names (symbols).}
}
\value{
A \code{tibble::tibble()} with the \code{MeanRatio} values for each gene x cell
type.
\itemize{
\item \code{gene} is the name of the gene (from rownames(\code{sce})).
\item \code{cellType.target} is the cell type we're finding marker genes for.
\item \code{mean.target} is the mean expression of \code{gene} for \code{cellType.target}.
\item \code{cellType.2nd} is the second highest non-target cell type.
\item \code{mean.2nd} is the mean expression of \code{gene} for \code{cellType.2nd}.
\item \code{MeanRatio} is the ratio of \code{mean.target/mean.2nd}.
\item \code{MeanRatio.rank} is the rank of \code{MeanRatio} for the cell type.
\item \code{MeanRatio.anno} is an annotation of the \code{MeanRatio} calculation helpful
for plotting.
\item \code{gene_ensembl} & \code{gene_name} optional columns from \code{rowData(sce)} specified
by the user to add gene information.
}
}
\description{
Calculate the Mean Ratio value and rank for each gene for each cell type in
the \code{sce} object, to identify effective marker genes for deconvolution.
}
\details{
Note if a cell type has < 10 cells the MeanRatio results may be unstable.
See rational in OSCA:
\url{https://bioconductor.org/books/3.19/OSCA.multisample/multi-sample-comparisons.html#performing-the-de-analysis}.
}
\examples{
## load example SingleCellExperiment
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")
## Explore properties of the sce object
sce_DLPFC_example

## this data contains logcounts of gene expression
SummarizedExperiment::assays(sce_DLPFC_example)$logcounts[1:5, 1:5]

## nuclei are classified in to cell types
table(sce_DLPFC_example$cellType_broad_hc)

## Get the mean ratio for each gene for each cell type defined in
## `cellType_broad_hc`
get_mean_ratio(sce_DLPFC_example, cellType_col = "cellType_broad_hc")

# Option to specify gene_name as the "Symbol" column from rowData
# this will be added to the marker stats output
SummarizedExperiment::rowData(sce_DLPFC_example)

## specify rowData col names for gene_name and gene_ensembl
get_mean_ratio(sce_DLPFC_example,
    cellType_col = "cellType_broad_hc",
    gene_name = "gene_name",
    gene_ensembl = "gene_id"
)

}
\seealso{
Other marker gene functions: 
\code{\link{findMarkers_1vAll}()}
}
\concept{marker gene functions}
