% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Adjust.R
\name{DaMiR.SVadjust}
\alias{DaMiR.SVadjust}
\title{Remove variable effects from expression data}
\usage{
DaMiR.SVadjust(data, sv, n.sv)
}
\arguments{
\item{data}{A SummarizedExpression object}

\item{sv}{The matrix of surrogate variables identified by
\code{\link{DaMiR.SV}} function}

\item{n.sv}{The number of surrogate variables to be used to adjust
the data}
}
\value{
A SummarizedExpression object containing a matrix of
log-expression
values with sv effects removed and the data frame of the variables.
}
\description{
This function removes surrogate or other confounding
variable effects from
normalized expression data by the usage of
\code{\link{removeBatchEffect}} function
 of \code{limma} package.
}
\examples{
# use example data:
data(data_norm)
data(sv)
data_adjust <- DaMiR.SVadjust(data_norm, sv = sv, n.sv = 3)

}
\seealso{
\code{\link{removeBatchEffect}},
\code{\link{DaMiR.SV}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
