% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.scVI.R
\name{DO.scVI}
\alias{DO.scVI}
\title{DO.scVI}
\usage{
DO.scVI(
  sce_object,
  batch_key,
  layer_counts = "counts",
  layer_logcounts = "logcounts",
  categorical_covariates = NULL,
  continuos_covariates = NULL,
  n_hidden = 128,
  n_latent = 30,
  n_layers = 3,
  dispersion = "gene-batch",
  gene_likelihood = "zinb",
  get_model = FALSE
)
}
\arguments{
\item{sce_object}{Seurat or SCE object with annotation in meta.data}

\item{batch_key}{meta data column with batch information.}

\item{layer_counts}{layer with counts. Raw counts are required.}

\item{layer_logcounts}{layer with log-counts. Log-counts required for
calculation of HVG.}

\item{categorical_covariates}{list of meta data column names with categorical
covariates for scVI inference.}

\item{continuos_covariates}{list of meta data  column names with continuous
covariates for scVI inference.}

\item{n_hidden}{number of hidden layers.}

\item{n_latent}{dimensions of the latent space.}

\item{n_layers}{number of layers.}

\item{dispersion}{dispersion mode for scVI.}

\item{gene_likelihood}{gene likelihood.}

\item{get_model}{return the trained model.}
}
\value{
Seurat or SCE Object with dimensionality reduction from scVI
}
\description{
This function will run the scVI Integration from the scVI python
package. It includes all parameters from the actual python package and runs
it by using an internal python script. The usage of a gpu is incorporated
and highly recommended.
}
\examples{
\dontrun{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

# Run scVI using the 'orig.ident' column as the batch key
sce_data <- DO.scVI(sce_data, batch_key = "orig.ident")
}

}
