% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.Dotplot.R
\name{DO.Dotplot}
\alias{DO.Dotplot}
\title{DO Dot plot}
\usage{
DO.Dotplot(
  sce_object,
  Feature,
  group.by.x = NULL,
  group.by.y = NULL,
  group.by.y2 = NULL,
  across.group.by.x = FALSE,
  across.group.by.y = FALSE,
  sort_x = NULL,
  sort_y = NULL,
  dot.size = c(1, 6),
  plot.margin = c(1, 1, 1, 1),
  midpoint = 0.5,
  scale_gene = FALSE,
  returnValue = FALSE,
  log1p_nUMI = TRUE,
  hide_zero = TRUE,
  annotation_x = FALSE,
  annotation_x_position = 0.25,
  annotation_x_rev = FALSE,
  point_stroke = 0.2,
  limits_colorscale = NULL,
  coord_flip = FALSE,
  stats_x = FALSE,
  stats_y = TRUE,
  sig_size = 6,
  nudge_x = 0.3,
  nudge_y = 0.2,
  ...
)
}
\arguments{
\item{sce_object}{The SCE object or Seurat}

\item{Feature}{Genes or DF of interest, Data frame should have columns with
gene and annotation information, e.g. output of FindAllMarkers}

\item{group.by.x}{group name to plot on x-axis}

\item{group.by.y}{group name to look for in meta data}

\item{group.by.y2}{second group name to look for in meta data}

\item{across.group.by.x}{calculate a pseudobulk expression approach for the
x-axis categories}

\item{across.group.by.y}{calculate a pseudobulk expression approach for the
y-axis categories}

\item{sort_x}{Vector sorting the xaxis}

\item{sort_y}{Vector to sort the yaxis}

\item{dot.size}{Vector of dot size}

\item{plot.margin}{= plot margins}

\item{midpoint}{midpoint in color gradient}

\item{scale_gene}{If True calculates the Z-score of the average expression
per gene}

\item{returnValue}{return the dataframe behind the plot}

\item{log1p_nUMI}{log1p the plotted values, boolean}

\item{hide_zero}{Removes dots for genes with 0 expression}

\item{annotation_x}{Adds annotation on top of x axis instead on y axis}

\item{annotation_x_position}{specifies the position for the annotation}

\item{annotation_x_rev}{reverses the annotations label order}

\item{point_stroke}{Defines the thickness of the black stroke on the dots}

\item{limits_colorscale}{Set manually colorscale limits}

\item{coord_flip}{flips the coordinates of the plot with each other}

\item{stats_x}{Perform statistical test over categories on the xaxis}

\item{stats_y}{Perform statistical test over categories on the yaxis}

\item{sig_size}{Control the size of the significance stars in the plot}

\item{nudge_x}{Control the position of the star on x axis}

\item{nudge_y}{Control the position of the star on y axis}

\item{...}{Further arguments passed to annoSegment function if
annotation_x == TRUE}
}
\value{
a ggplot
}
\description{
This function generates a dot plot for multiple genes, comparing
expression levels across one or two specified groups. It supports both
individual and pseudobulk expression calculations. Highly variable
customization options allow control over dot size, color scaling,
annotations, and axis orientation. The function integrates seamlessly with
SCE objects for single-cell RNA-seq analysis.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.Dotplot(
    sce_object = sce_data,
    Feature = c("NKG7", "IL6", "MALAT1"),
    group.by.x = "condition"
)

}
\author{
Mariano Ruz Jurado
}
