% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.DietSCE.R
\name{DO.DietSCE}
\alias{DO.DietSCE}
\title{Remove Layers from Seurat or SCE Object by Pattern}
\usage{
DO.DietSCE(sce_object, assay = "RNA", pattern = "^scale\\\\.data\\\\.")
}
\arguments{
\item{sce_object}{Seurat or SCE object.}

\item{assay}{Name of the assay from where to remove layers from}

\item{pattern}{regular expression pattern to match layer names. Default
"^scale\\.data\\."}
}
\value{
Seurat or SCE object with specified layers removed.
}
\description{
This function removes layers from a Seurat or SCE object's RNA
assay based on a specified regular expression pattern. It is supposed to
remove no longer needed layers from th object.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

sce_data <- DO.DietSCE(sce_data, pattern = "data")

}
\author{
Mariano Ruz Jurado
}
