% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.CellComposition.R
\name{DO.CellComposition}
\alias{DO.CellComposition}
\title{DO CellComposition}
\usage{
DO.CellComposition(
  sce_object,
  assay_normalized = "RNA",
  cluster_column = "seurat_clusters",
  sample_column = "orig.ident",
  condition_column = "condition",
  transform_method = "logit",
  sort_x = NULL,
  sub_ident = NULL,
  sort_fill = NULL,
  scanpro_plots = FALSE,
  scanpro_group = NULL,
  outputFolder = NULL,
  return_df = FALSE,
  bar_colors = NULL,
  n_reps = NULL,
  legend.pos.x = 0.48,
  legend.pos.y = 0,
  cowplot_width = 0.9,
  cowlegend_width = 0.9,
  random_seed = 42,
  ...
)
}
\arguments{
\item{sce_object}{The SCE object or Seurat}

\item{assay_normalized}{Assay with raw counts}

\item{cluster_column}{Column in meta data which will be used to segment the
bar plot}

\item{sample_column}{Column in meta data containing individual sample names}

\item{condition_column}{Column in meta data plotted on the xaxis}

\item{transform_method}{Method of transformation of proporties, default:
"logit"}

\item{sort_x}{Vector sorting the xaxis}

\item{sub_ident}{vector to subset the whole plot by}

\item{sort_fill}{Vector sorting the bar segments}

\item{scanpro_plots}{Boolean, will create plots provided in scanpro package,
default: FALSE}

\item{scanpro_group}{Defines the clusters showed in scanpro plots}

\item{outputFolder}{Scanpro plots will be saved in this directory, defaults
to current working directory}

\item{return_df}{Boolean, makes a list with first entry beeaing the
dataframe used to create the ggplot and second entry is the plot}

\item{bar_colors}{(named) vector of colors used for plotting, the names will
be sued to factorize the segments}

\item{n_reps}{Number of replicates generated by scanpro}

\item{legend.pos.x}{adjusts the position of the legend in horizontal}

\item{legend.pos.y}{adjusts the position of the legend in vertical}

\item{cowplot_width}{Changes the width on the plotting device for plot}

\item{cowlegend_width}{Changes the width on the plotting device for legend,
useful for adjusting the legend position in combination with legend.pos.x
and y}

\item{random_seed}{parameter for random state initialisation}

\item{...}{Further arguments passed to scanpro plotting functions}
}
\value{
ggplot object or list
}
\description{
Computes and visualizes cell composition changes from a Seurat
object using Scanpro. Integrates R and Python via reticulate to convert
Seurat to AnnData and run Scanpro. Generates customizable plots with options
for transformation, grouping, and bootstrapping. Returns a ggplot object or
a list containing plot data and visualisation.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.CellComposition(
    sce_object = sce_data,
    cluster_column = "annotation",
    condition_column = "condition",
    scanpro_plots = FALSE,
    n_reps = 5
)

}
\author{
Mariano Ruz Jurado
}
