% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot PCA for simulated RNA-seq or Ribo-seq data}
\usage{
plot_pca(
  gcoeff,
  bcoeff,
  batch_scenario,
  num_batches,
  countdata,
  coldata,
  strategy = c("ribo", "rna"),
  formula1 = ~strategy,
  formula2 = ~condition + batch
)
}
\arguments{
\item{gcoeff}{Numeric. Magnitude of log-fold change for DOT effects.}

\item{bcoeff}{Numeric vector. Batch effect coefficients.}

\item{batch_scenario}{Character. Describes the batch effect design
(e.g., \code{"balanced"}, \code{"confounded"}).}

\item{num_batches}{Integer. Number of batches.}

\item{countdata}{A matrix or data frame of raw counts (genes x samples).}

\item{coldata}{A data frame containing sample metadata. Must include
\code{condition}, \code{batch}, and \code{strategy} columns.}

\item{strategy}{Character string. Specifies which strategy to plot
(e.g., \code{"rna"} or \code{"ribo"}).}

\item{formula1}{A formula object specifying the initial design for
DESeq2 object construction. Default is \code{~strategy}.}

\item{formula2}{A formula object specifying the design for PCA modeling.
Default is \code{~ condition + batch}.}
}
\value{
A PCA plot is rendered to the active graphics device. The plot
includes sample points colored by condition and shaped by batch, with
legends placed dynamically to avoid overlap.
}
\description{
Generates a PCA plot from simulated RNA-seq or Ribo-seq count data,
highlighting sample-level variation across conditions and batches.
The function applies variance-stabilizing transformation (VST),
performs principal component analysis (PCA), and dynamically adjusts
plot margins to accommodate legends based on device size and label width.
}
\keyword{internal}
