% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_orf_usage}
\alias{plot_orf_usage}
\title{Plot ORF usage across conditions with significance annotations}
\usage{
plot_orf_usage(
  data,
  gene_id = NULL,
  id_mapping = NULL,
  levels = NULL,
  dou_signif_thresh = 0.05,
  colors = "Set2"
)
}
\arguments{
\item{data}{A \code{\link{DOUData-class}} object with an
\code{interaction} slot storing interaction-specific post hoc
contrast results.}

\item{gene_id}{A character string specifying the gene ID of interest}

\item{id_mapping}{Optional data frame with gene symbols (e.g.,
from biomaRt). Used to label heatmap rows with gene symbols.}

\item{levels}{Optional character vector specifying the order of
conditions on the x-axis.}

\item{dou_signif_thresh}{Numeric threshold for significance
annotation (default is \code{0.05}).}

\item{colors}{Color palette for
\code{\link[ggplot2]{scale_fill_brewer}}. Default is
\code{Set2}.}
}
\value{
A \code{ggplot} object visualizing ORF usage across
conditions, with significance annotations for contrasts passing
\code{dou_signif_thresh}. ORFs with non-significant contrasts are
not annotated.
}
\description{
Generates a faceted bar plot of ORF usage across experimental
conditions, with optional significance annotations based on adjusted
p-values (e.g., LFSR). Requires
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2} and
\href{https://CRAN.R-project.org/package=ggsignif}{ggsignif}.
}
\keyword{internal}
