% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{parse_condition_table}
\alias{parse_condition_table}
\title{Parse and validate sample metadata for DOTSeq analysis}
\usage{
parse_condition_table(condition_table)
}
\arguments{
\item{condition_table}{A character string specifying the path to a
tab-delimited metadata file, or a data frame containing sample metadata.
The metadata must include the following columns (case-insensitive):
\code{run}, \code{strategy}, \code{condition}, and \code{replicate}.}
}
\value{
A data frame with normalized column names and row names set to
the \code{run} column. Used internally to construct the
\code{\link{DOTSeqDataSets-class}} object.
}
\description{
This internal helper function reads and validates the sample metadata
provided either as a file path or a data frame. It ensures that the
required columns—\code{run}, \code{strategy}, \code{condition}, and
\code{replicate}—are present (case-insensitive match), and normalizes
column names for consistency. If a file path is provided, the function
reads the file and checks the header before loading the full table.
If a data frame is provided, it performs similar validation directly.
}
\keyword{internal}
