% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{modelType}
\alias{modelType}
\alias{modelType,PostHoc-method}
\alias{fitResults}
\alias{fitResults,PostHoc-method}
\alias{posthoc}
\alias{posthoc,PostHoc-method}
\title{Access the model type from a PostHoc object}
\usage{
modelType(object)

\S4method{modelType}{PostHoc}(object)

fitResults(object)

\S4method{fitResults}{PostHoc}(object)

posthoc(object)

\S4method{posthoc}{PostHoc}(object)
}
\arguments{
\item{object}{A \code{PostHoc} object.}
}
\value{
A \code{character(1)} string indicating the model type.

A \code{list} containing model results and diagnostics.

A post hoc summary object.
}
\description{
Retrieves the model type string from a \code{PostHoc} object.

Retrieves model results, parameters, and diagnostics.

Retrieves the post hoc summary object (e.g. from \code{\link[emmeans]{emmeans}}).
}
\section{Functions}{
\itemize{
\item \code{modelType(PostHoc)}: Access the model type from a PostHoc object.

\item \code{fitResults(PostHoc)}: Access the results list.

\item \code{posthoc(PostHoc)}: Access the post hoc summary.

}}
\examples{
ph <- PostHoc(type = "glmmTMB")
modelType(ph)
ph <- PostHoc(results = list(aic = 100))
fitResults(ph)
ph <- PostHoc(posthoc = "dummy_emmeans")
posthoc(ph)
}
