% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichNCG.R
\name{enrichNCG}
\alias{enrichNCG}
\title{enrichNCG}
\usage{
enrichNCG(
  gene,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  readable = FALSE
)
}
\arguments{
\item{gene}{a vector of entrez gene id}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{minGSSize}{minimal size of genes annotated by NCG category for testing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{qvalueCutoff}{qvalue cutoff}

\item{readable}{whether mapping gene ID to gene Name}
}
\value{
A \code{enrichResult} instance
}
\description{
Enrichment analysis based on the Network of Cancer Genes database (http://ncg.kcl.ac.uk/)
}
\details{
given a vector of genes, this function will return the enrichment NCG
categories with FDR control
}
\author{
Guangchuang Yu
}
