% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/utilities-exported.R
\name{filterNetworks}
\alias{filterNetworks}
\alias{filterNetworks,DNEA-method}
\alias{filterNetworks,list-method}
\title{Filter the adjacency matrices to only the edges that meet the
filter conditions}
\usage{
filterNetworks(data, pcor, top_percent_edges)

\S4method{filterNetworks}{DNEA}(data, pcor, top_percent_edges)

\S4method{filterNetworks}{list}(data, pcor, top_percent_edges)
}
\arguments{
\item{data}{A \code{\link[=DNEA-class]{DNEA}} object.}

\item{pcor}{A partial correlation value of which to threshold
the adjacency matrices. Edges with pcor values <= to this
value will be removed.}

\item{top_percent_edges}{A value between 0-1 that corresponds to
the top x\% edges to keep in each network, respectively
(i.e. top_percent_edges = 0.1 will keep only the top 10\%
strongest edges in the networks).}
}
\value{
The input object after filtering the egdes in the
network according to the specified parameters.
}
\description{
This function takes as input a \code{\link[=DNEA-class]{DNEA}} object and
allows the user to filter the network edges by one of two methods:

\enumerate{
\item \strong{Partial Correlation} - The networks can be filtered to
only include edges greater than or equal to a specified partial
correlation (pcor) value.
\item \strong{Top \emph{X\%} of edges} - The networks can be filtered
to only include the strongest \emph{X\%} of edges determined
by their partial correlation values.}

Filtering is performed on the case and control adjacency matrices
separately. \cr
}
\examples{
#dnw is a \code{\link[=DNEA-class]{DNEA}} object with the results
#generated for the example data accessed by running
#data(TEDDY) in the console. The workflow for this data
#can be found in the vignette accessed by running
#browseVignettes("DNEA") in the console.
data(dnw)

#filter the networks by a correlation threshold of 0.166
dnw <- filterNetworks(dnw, pcor=0.166)

#filter networks for the top 40\% strongest correlations
dnw <- filterNetworks(dnw, top_percent_edges=0.4)

}
\seealso{
\code{\link{getNetworks}},\code{\link{adjacencyMatrix}}
}
\author{
Christopher Patsalis
}
