% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractGC.R
\name{extractGC}
\alias{extractGC}
\title{Extract GC}
\usage{
extractGC(methylationData, genome, contexts = c("ALL", "CG", "CHG", "CHH"))
}
\arguments{
\item{methylationData}{the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{genome}{a BSgenome with the DNA sequence of the organism}

\item{contexts}{the context in which the DMRs are computed (\code{"ALL"}, 
\code{"CG"}, \code{"CHG"} or \code{"CHH"}).}
}
\value{
the a subset of \code{methylationData} consisting of all GC sites.
}
\description{
This function extracts GC sites in the genome
}
\examples{

\dontrun{
# load the genome sequence
if(!require("BSgenome.Athaliana.TAIR.TAIR9", character.only = TRUE)){
  if (!requireNamespace("BiocManager", quietly=TRUE))
  install.packages("BiocManager")
  BiocManager::install("BSgenome.Athaliana.TAIR.TAIR9")
}
library(BSgenome.Athaliana.TAIR.TAIR9)

# load the methylation data
data(methylationDataList)

methylationDataWTGpCpG <- extractGC(methylationDataList[["WT"]], 
                                    BSgenome.Athaliana.TAIR.TAIR9,
                                    "CG")

}

}
\author{
Ryan Merritt
}
