% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePMDs.R
\name{analyseReadsInsideRegionsForConditionPMD}
\alias{analyseReadsInsideRegionsForConditionPMD}
\title{Analyse reads inside regions for condition}
\usage{
analyseReadsInsideRegionsForConditionPMD(
  regions,
  methylationData,
  context,
  label = "",
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{regions}{a \code{\link[GenomicRanges]{GRanges}} object with a list of regions on the 
genome; e.g. could be a list of PMDs}

\item{methylationData}{the methylation data in one condition
(see \code{\link{ontSampleGRangesList}}).}

\item{context}{the context in which to extract the reads (\code{"CG"}, 
\code{"CHG"} or \code{"CHH"}).}

\item{label}{a string to be added to the columns to identify the condition}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
a \code{\link[GenomicRanges]{GRanges}} object with additional four metadata columns
\describe{
 \item{sumReadsM}{the number of methylated reads}
 \item{sumReadsN}{the total number of reads} 
 \item{proportion}{the proportion methylated reads} 
 \item{cytosinesCount}{the number of cytosines in the regions} 
}
}
\description{
This function extracts from the methylation data the total number of reads, 
the number of methylated reads and the number of cytosines in the specific 
context from a region (e.g. PMDs)
}
\examples{

# load the ONT methylation data
data(ontSampleGRangesList)
 
#load the PMDs in CG context. These PMDs were computed with minGap = 200.
data(PMDsNoiseFilterCG)

#retrive the number of reads in CG context in GM18501
PMDsNoiseFilterCGreadsCG <- analyseReadsInsideRegionsForConditionPMD(
                             PMDsNoiseFilterCG[1:10], 
                             ontSampleGRangesList[["GM18501"]], context = "CG", 
                             label = "GM18501")


}
\seealso{
\code{\link{filterPMDs}}, \code{\link{computePMDs}}, 
\code{\link{PMDsNoiseFilterCG}}, and \code{\link{mergePMDsIteratively}}
}
\author{
Nicolae Radu Zabet and Young Jun Kim
}
