% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCpGranges.R
\name{makeCpGregions}
\alias{makeCpGregions}
\title{Cluster}
\usage{
makeCpGregions(observations, chr, pos, maxGap = 500, minCpG = 2)
}
\arguments{
\item{observations}{Vector of corresponding observed T-value for each CpG, 
must be ordered in the same way as chr and pos}

\item{chr}{Vector of chromosome location for each CpG}

\item{pos}{Vector giving base pair position for each CpG If unsorted, 
use order(chr,pos) to sort the genomic positions within each chromosome.}

\item{maxGap}{Maximum allowed base pair gap within a cluster. 
Default is set to 500.}

\item{minCpG}{Minimum number of CpGs allowed in each region to be 
considered. Default is set to at least 2 CpGs within each region.}
}
\value{
The suplied observations ordered into into a GRangesList object. 
To be parsed further into \code{\link{dmrscan}}
}
\description{
Cluster CpGs together in regions based on proximity
}
\examples{
data(DMRScan.methylationData) ## Load methylation data from chromosome 22
data(DMRScan.phenotypes) ## Load phenotype (end-point for methylation data)

## Test for an association between phenotype and Methylation
testStatistics <- apply(DMRScan.methylationData,1,function(x,y)
 summary(glm(y ~ x, family = binomial(link = "logit")))$coefficients[2,3],
 y = DMRScan.phenotypes)

## Set chromosomal position to each test-statistic
pos<- data.frame(matrix(as.integer(unlist(strsplit(names(testStatistics),
split="chr|[.]"))), ncol = 3, byrow = TRUE))[,-1] 

## Set clustering features 
minCpG <- 3  ## Minimum number of CpGs in a tested cluster 
## Maxium distance (in base-pairs) within a cluster before it is 
## broken up into two seperate cluster
maxGap <- 750  
regions <- makeCpGregions(observations = testStatistics, chr = pos[,1], 
                            pos = pos[,2], maxGap = maxGap, minCpG = minCpG)
}
\keyword{CpG}
\keyword{Regions}
