% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsp_test.R
\name{dsp_test}
\alias{dsp_test}
\title{dsp_test}
\usage{
dsp_test(
  spe,
  design = NULL,
  cluster_col,
  sample_col,
  condition_col,
  min_counts = 20,
  min_non_zero_spots = 10,
  min_pct_cells = 0.5,
  filter_gene = FALSE,
  filter_cluster = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment.}

\item{design}{Matrix or array. Numeric design matrix for a 
regression-like model created by `model.matrix` function.}

\item{cluster_col}{Character. Column name of spatial clusters in \code{colData(spe)}.}

\item{sample_col}{Character. Column name of sample ids in \code{colData(spe)}.
Sample ids must be either a factor or character.}

\item{condition_col}{Character. Column name of condition ids in \code{colData(spe)}.}

\item{min_counts}{Numeric. Minimum number of counts per sample 
(across all spots) for a gene to be analyzed.}

\item{min_non_zero_spots}{Numeric. Minimum number of non-zero spots 
per sample, for a gene to be analyzed.}

\item{min_pct_cells}{Numeric. Minimum percentage of cells required for each cluster to be 
included in the analysis across the specified conditions. 
Default value is 0.5 (i.e., 0.5\% of total cells per cluster per condition).}

\item{filter_gene}{Logical. 
If TRUE, \code{\link{dsp_test}} filters genes by requiring them to be expressed 
in at least 'min_non_zero_spots' cells and have at least 'min_counts'
 counts per sample across all locations.}

\item{filter_cluster}{Logical. When set to TRUE, 
\code{\link{dsp_test}} excludes clusters that are 
insufficiently represented in the dataset. 
Only clusters meeting the 'min_pct_cells' threshold 
(i.e., containing at least the specified percentage of cells 
across all conditions) will be retained for analysis.}

\item{verbose}{Logical.
If TRUE, \code{\link{svg_test}} returns two more results: 
'DGEGLM' and 'DGELRT' objects contain full statistics from 
'edgeR::glmFit' and 'edgeR::glmLRT'.}
}
\value{
A list of results:

- "gene_results": a dataframe contains main edgeR test results;

- "estimated_y": a DGEList object contains the estimated common dispersion, 
which can later be used to speed-up calculation when testing individual clusters.

- "glmFit" (only if \code{verbose = TRUE}): a DGEGLM object contains full statistics from "edgeR::glmFit".

- "glmLRT" (only if \code{verbose = TRUE}): a DGELRT object contains full statistics from "edgeR::glmLRT".
}
\description{
'dsp_test' identifies differential spatial pattern (DSP) genes 
between conditions from spatially-resolved transcriptomics data,
provided spatial clusters are available.
}
\examples{
## Load the example multi-sample multi-group spe object
spe <- muSpaData::Wei22_example()
# Fit the model via \code{\link{dsp_test}} function.
set.seed(123)
results_dsp <- dsp_test(spe = spe,
                        cluster_col = "Banksy_smooth",
                        sample_col = "sample_id",
                        condition_col = "condition",
                        verbose = FALSE)

# dsp_test returns of an object:
# "gene_results": a dataframe contains main edgeR test results.

# We visualize differential results:
head(results_dsp, 3)

}
\seealso{
\code{\link{svg_test}}, \code{\link{individual_svg}}, \code{\link{individual_dsp}}, \code{\link{FeaturePlot}}, \code{\link{top_results}}
}
