% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_LIBD_subset.R
\name{LIBD_subset}
\alias{LIBD_subset}
\title{Subset from the human DLPFC 10x Genomics Visium dataset of the \code{spatialLIBD} package}
\arguments{
\item{LIBD_subset}{contains a \code{\link[SpatialExperiment]{SpatialExperiment-class}} object,
representing a subset of the sample 151673 from the full real data of the \code{spatialLIBD} package.
Below the code used to subset the original dataset.}
}
\value{
A spatial experiment object
}
\description{
Subset from the human DLPFC 10x Genomics Visium dataset of the \code{spatialLIBD} package
}
\examples{
# Connect to ExperimentHub
# ehub <- ExperimentHub::ExperimentHub()
# Download the example spe data
# spe_all <- spatialLIBD::fetch_data(type = "spe", eh = ehub)
# Select one sample only:
# LIBD_subset <- spe_all[, colData(spe_all)$sample_id == '151673']
# Select small set of random genes for faster runtime 
# set.seed(123)
# sel_genes <- sample(dim(LIBD_subset)[1],500)
# LIBD_subset <- LIBD_subset[sel_genes,]
# keep_col <- c("array_row","array_col","layer_guess_reordered")
# library(SingleCellExperiment)
# LIBD_subset <- SpatialExperiment(assay = list(counts = assay(LIBD_subset),
#                                               logcounts = logcounts(LIBD_subset)), 
#                                  colData = colData(LIBD_subset)[keep_col])
# save(LIBD_subset, file = "./DESpace/data/LIBD_subset.RData")
}
\seealso{
\code{\link{svg_test}}, \code{\link{individual_svg}}
}
\author{
Peiying Cai \email{peiying.cai@uzh.ch}, Simone Tiberi \email{simone.tiberi@unibo.it}
}
