% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_analysis.R
\name{postHocTest}
\alias{postHocTest}
\title{Post-hoc tests for classic 1-way ANOVA}
\usage{
postHocTest(aov_fits, post_hoc_test = "TukeyHSD")
}
\arguments{
\item{aov_fits}{a list containing aov fitted model objects}

\item{post_hoc_test}{a character string indicating which post-hoc test to
use. Possible values are "TukeyHSD" or "Dunnett". See details for what to
choose according to your experimental design.}
}
\value{
a list of 2 dataframes: first one called "LogFC" contains
all pairwise comparisons logFC values (one column for one comparison) for
each analysed feature; The second one named "P_Value" contains the
corresponding pvalues.
}
\description{
This function allows to compute a post-hoc test after a 1-way
ANOVA analysis. It expects as input an object obtained with the function
\code{classic1wayAnova}. The second parameter allows to choose between 2
different post-hoc tests: the Tukey Honest Significant Differences
(specified as "TukeyHSD") and the Dunnett test (specified as "Dunnett").
}
\details{
This is a function allowing to realise post-hoc tests for a set of
proteins/peptides for which a classic 1-way anova has been performed with
the function \code{classic1wayAnova}. Two types of tests are currently
available: The Tukey HSD's test and the Dunnett's test. Default is Tukey's
test.
The Tukey HSD's test compares all possible pairs of means, and is based on a
studentized range distribution. Here is used the \code{TukeyHSD()} function,
which can be applied to balanced designs (same number of samples in each
group), but also to midly unbalanced designs.
The Dunnett's test compares a single control group to all other groups.
Make sure the factor levels are properly ordered.
}
\examples{
\dontrun{examples/ex_postHocTest.R}

}
\author{
Hélène Borges
}
