% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pepa.R
\name{pepa.test}
\alias{pepa.test}
\title{PEptide based Protein differential Abundance test}
\usage{
pepa.test(X, y, n1, n2, global = FALSE, use.lm = FALSE)
}
\arguments{
\item{X}{Binary q x p design matrix for q peptides and p
proteins. X_(ij)=1 if peptide i belongs to protein j, 0 otherwise.}

\item{y}{q x n matrix representing the log intensities of q peptides
among n MS samples.}

\item{n1}{number of samples under condition 1. It is assumed that the first
n1 columns of y correspond to observations under condition 1.}

\item{n2}{number of samples under condition 2.}

\item{global}{if TRUE, the test statistic for each protein uses all
residues, including the ones for peptides in different connected
components. Can be much faster as it does not require to compute
connected components. However the p-values are not well calibrated
in this case, as it amounts to adding a ridge to the test
statistic. Calibrating the p-value would require knowing the
amplitude of the ridge, which in turns would require computing the
connected components.}

\item{use.lm}{if TRUE (and if global=FALSE), use lm() rather than the result
in Proposition 1 to compute the test statistic}
}
\value{
A list of the following elements:
llr: log likelihood ratio statistic (maximum likelihood version).
llr.map: log likelihood ratio statistic (maximum a posteriori version).
llr.pv: p-value for llr.
llr.map.pv: p-value for llr.map.
mse.h0: Mean squared error under H0
mse.h1: Mean squared error under H1
s: selected regularization hyperparameter for llr.map.
wchi2: weight used to make llr.map chi2-distributed under H0.
}
\description{
PEptide based Protein differential Abundance test
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
protID <- "Protein_group_IDs"
obj <- Exp1_R25_pept[seq_len(20)]
X <- BuildAdjacencyMatrix(obj, protID, FALSE)

}
\author{
Thomas Burger, Laurent Jacob
}
