% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{metacombine}
\alias{metacombine}
\title{Combine peptide metadata to build protein metadata}
\usage{
metacombine(met, level)
}
\arguments{
\item{met}{xxx}

\item{level}{xxx}
}
\value{
xxx
}
\description{
Aggregation rules for the cells metadata of peptides.
Please refer to the metacell vocabulary in `metacell.def()`

# Basic aggregation
(RULE 1) Aggregation of a mix of missing values (2.X) with quantitative 
and/or imputed values (1.X, 3.X)
|----------------------------
 Not possible (tag : 'STOP')
|----------------------------

Aggregation of different types of missing values (among 2.1, 2.2)
|----------------------------
* (RULE 2) Aggregation of 2.1 peptides between each other gives a missing value (2.0)
* (RULE 3) Aggregation of 2.2 peptides between each other gives a missing value (2.0)
* (RULE 4) Aggregation of a mix of 2.1 and 2.2 gives a missing value (2.0)
|----------------------------


Aggregation of a mix of quantitative and/or imputed values (among 1.x and 3.X)
|----------------------------
* (RULE 5) if the type of all the peptides to agregate is either 1.0, 1.1 or 1.2,
then the final metadata is set to the corresponding tag
* (RULE 5bis) if the type of all the peptides to agregate is either 3.0, 3.1 or 3.2,
then the final metadata is set to the corresponding tag
* (RULE 6) if the set of metacell to agregate is a mix of 1.x, then the final metadata is set to 1.0
* (RULE 7) if the set of metacell to agregate is a mix of 3.x, then the final metadata is set to 3.0
* (RULE 8) if the set of metacell to agregate is a mix of 3.X and 1.X,
then the final metadata is set to 4.0

# Post processing
Update metacell with POV/MEC status for the categories 2.0 and 3.0
TODO
}
\examples{
ll <- metacell.def("peptide")$node
for (i in seq_len(length(ll))) {
  test <- lapply(
    combn(ll, i, simplify = FALSE),
    function(x) tag <- metacombine(x, "peptide")
  )
}

metacombine(c('Quant. by direct id', 'Missing POV'), 'peptide')
}
