% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_density_CV.R
\name{CVDistD_HC}
\alias{CVDistD_HC}
\title{Distribution of CV of entities}
\usage{
CVDistD_HC(qData, conds = NULL, pal = NULL)
}
\arguments{
\item{qData}{A dataframe that contains quantitative data.}

\item{conds}{A vector of the conditions (one condition per sample).}

\item{pal}{xxx}
}
\value{
A density plot
}
\description{
Builds a densityplot of the CV of entities in the Biobase::exprs() table
of a object. The CV is calculated for each condition present
in the dataset (see the slot \code{'Condition'} in the 
\code{Biobase::pData()} table)
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
conds <- Biobase::pData(Exp1_R25_pept)[, "Condition"]
CVDistD_HC(Biobase::exprs(Exp1_R25_pept), conds)
pal <- ExtendPalette(2, "Dark2")
CVDistD_HC(Biobase::exprs(Exp1_R25_pept), conds, pal)

}
\author{
Samuel Wieczorek
}
