% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStep.R
\name{CytoProcessingStep}
\alias{CytoProcessingStep}
\alias{CytoProcessingStep-class}
\alias{characterOrFunction-class}
\alias{show,CytoProcessingStep-method}
\alias{executeProcessingStep}
\alias{getCPSName}
\alias{getCPSFUN}
\alias{getCPSARGS}
\alias{as.list.CytoProcessingStep}
\alias{as.json.CytoProcessingStep}
\alias{from.json.CytoProcessingStep}
\title{Cyto Processing step}
\usage{
CytoProcessingStep(name = character(), FUN = character(), ARGS = list())

\S4method{show}{CytoProcessingStep}(object)

executeProcessingStep(x, ...)

getCPSName(x)

getCPSFUN(x)

getCPSARGS(x)

\method{as.list}{CytoProcessingStep}(x, ...)

as.json.CytoProcessingStep(x, pretty = FALSE)

from.json.CytoProcessingStep(jsonString)
}
\arguments{
\item{name}{\code{character} denoting a name to the step, which can be different
from the function name}

\item{FUN}{\code{function} or \code{character} representing a function name.}

\item{ARGS}{\code{list} of arguments to be passed along to \code{FUN}.}

\item{object}{a \code{CytoProcessingStep} object.}

\item{x}{a \code{CytoProcessingStep} object.}

\item{...}{other arguments (not used)}

\item{pretty}{formatting set-up (see jsonlite::toJSON doc)}

\item{jsonString}{a \code{character()} containing a JSON string.}
}
\value{
The \code{CytoProcessingStep} function returns and object of type
\code{CytoProcessingStep}.
}
\description{
Class containing the function and arguments to be applied in a lazy-execution
framework.

Objects of this class are created using the \code{CytoProcessingStep()}
function.
The processing step is executed with the \code{executeProcessingStep()}
function.
}
\details{
This object contains all relevant information of a data analysis processing
step, i.e. the function and all of its arguments to be applied to the data.
}
\examples{

## Create a simple processing step object
ps1 <- CytoProcessingStep("summing step", sum)

getCPSName(ps1)

getCPSFUN(ps1)

getCPSARGS(ps1)

executeProcessingStep(ps1, 1:10)

as.list(ps1)

js_str <- as.json.CytoProcessingStep(ps1)

ps2 <- from.json.CytoProcessingStep(js_str)

identical(ps1, ps2)

}
