% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet2cytobank.R
\name{gatingset_to_cytobank}
\alias{gatingset_to_cytobank}
\alias{GatingSet2cytobank}
\title{Convert a GatingSet to a Cytobank-compatible gatingML}
\usage{
gatingset_to_cytobank(
  gs,
  outFile,
  showHidden = FALSE,
  cytobank.default.scale = TRUE,
  ...
)
}
\arguments{
\item{gs}{a GatingSet object}

\item{outFile}{a file name}

\item{showHidden}{whether to include the hidden population nodes in the output}

\item{cytobank.default.scale}{logical flag indicating whether to use the default Cytobank asinhtGml2 settings.
Currently it should be set to TRUE in order for gates to be displayed properly in Cytobank
because cytobank currently does not parse the global scale settings from GatingML.}

\item{...}{rescale.gate default is TRUE. which means the gate is rescaled to the new scale that is understandable by cytobank.
It is recommended not to change this behavior unless user wants to export to a gatingML file used for other purpose other
than being imported into cytobank.}
}
\value{
nothing
}
\description{
this function retrieves the gates from GatingSet and writes a customed GatingML-2.0 file
that can be imported into cytobank.
}
\details{
The process can be divided into four steps:
1. Read in gate geometry, compensation and transformation from gatingSet
2. Rescale gate boundaries with flowjo_biexp() so gates can be displayed properly in Cytobank
3. Save gates and hierarchy structure to R environment
4. Write environment out to gatingML using write.GatingML()
}
\examples{
library(flowWorkspace)

dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))

gs_pop_remove(gs, "CD8")

#output to cytobank
outFile <- tempfile(fileext = ".xml")
gatingset_to_cytobank(gs, outFile) #type by default is 'cytobank'

}
