% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cytoglmm.R
\name{summary.cytoglmm}
\alias{summary.cytoglmm}
\title{Extact and calculate p-values of GLMM fit}
\usage{
\method{summary}{cytoglmm}(object, method = "BH", ...)
}
\arguments{
\item{object}{A \code{cytoglmm} class}

\item{method}{Multiple comparison adjustment method}

\item{...}{Other parameters}
}
\value{
\code{\link[tibble]{tibble}} data frame
}
\description{
Extact and calculate p-values of GLMM fit
}
\examples{
set.seed(23)
df <- generate_data()
protein_names = names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glmm_fit <- CytoGLMM::cytoglmm(df,
                              protein_names = protein_names,
                              condition = "condition",
                              group = "donor")
summary(glmm_fit)
}
