% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cytoglmm.R
\name{print.cytoglmm}
\alias{print.cytoglmm}
\title{Extact and print GLMM fit}
\usage{
\method{print}{cytoglmm}(x, ...)
}
\arguments{
\item{x}{A \code{cytoglmm} class}

\item{...}{Other parameters}
}
\value{
NULL.
}
\description{
Extact and print GLMM fit
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
glmm_fit <- CytoGLMM::cytoglmm(df,
                              protein_names = protein_names,
                              condition = "condition",
                              group = "donor")
print(glmm_fit)
}
