% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_selection.R
\name{plot_model_selection}
\alias{plot_model_selection}
\title{Plot model selection to choose number optimal number of clusters}
\usage{
plot_model_selection(fit, k = NULL)
}
\arguments{
\item{fit}{A \code{cytoflexmix} class}

\item{k}{Number of clusters}
}
\value{
\code{\link[cowplot]{cowplot}} object
}
\description{
Plot model selection to choose number optimal number of clusters
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
mix_fit <- CytoGLMM::cytoflexmix(df,
                                 protein_names = protein_names,
                                 condition = "condition",
                                 group = "donor",
                                 ks = 1:2)
plot_model_selection(mix_fit)
}
