% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs2DF.R
\name{fcs2DF}
\alias{fcs2DF}
\title{Convert fcs files to a data frame}
\usage{
fcs2DF(fcsFiles, y = NULL, assay = c("FCM", "CyTOF"), b = 1/200,
  fileSampleSize = 5000, compFiles = NULL, nameDict = NULL,
  excludeTransformParameters = c("FSC-A", "FSC-W", "FSC-H", "Time",
  "Cell_length"))
}
\arguments{
\item{fcsFiles}{A vector specifying the location of fcs files (relative to
working directory).}

\item{y}{A vector containing the clinical outcome of each sample. Must have
the same length as fcsFiles. Null for testing data.}

\item{assay}{Either "FCM" or "CyTOF" to indicate the type of cytometry data.}

\item{b}{A positive number used to specify the arcsinh transformation. f(x) =
asinh (b*x) where x is the original value and f(x) is the value after
transformation. The suggested value is 1/150 for flow cytometry (FCM) data
and 1/8 for CyTOF data.}

\item{fileSampleSize}{An integer specifying the number of events sampled from
each fcs file. If NULL, all the events will be pre-processed and wrote out
to the new fcs files.}

\item{compFiles}{A vector specifying the paths of user supplied compensation
matrix for each fcs file. The matrix must be stored in csv files.}

\item{nameDict}{A vector used to change marker names.Each element in the
vector is the prefered name of a marker. The name of each element is the
marker name used in the fcs file. For example, a vector
c("CD8b"="CD8","cd8"="CD8") will change "CD8b" and "cd8" into "CD8", making
annotations more consistent.}

\item{excludeTransformParameters}{A vector specifying the name of parameters
not to be transformed (left at linear scale).}
}
\value{
Returns a data frame containing the preprocessed cytometry data.
  Cells from different fcs files are combined into one flow frame. A new
  column, xSample, is introduced to indicate the origin of each cell. The
  data frame also includes the clinical outcome y.
}
\description{
A function that convert fcs files to a data frame.
}
\examples{
# Find the table containing fcs file names in CytoDx package
path <- system.file("extdata",package="CytoDx")
# read the table
fcs_info <- read.csv(file.path(path,"fcs_info.csv"))
# Specify the path to the cytometry files
fn <- file.path(path,fcs_info$fcsName)
# Read cytometry files using fcs2DF function
train_data <- fcs2DF(fcsFiles=fn,
                    y=fcs_info$Label,
                    assay="FCM",
                    b=1/150,
                    excludeTransformParameters=
                      c("FSC-A","FSC-W","FSC-H","Time"))
}
