% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{update_unharmonised}
\alias{update_unharmonised}
\title{Update the unharmonised parquet files}
\usage{
update_unharmonised(unharmonised_parquet_dir, ...)
}
\arguments{
\item{unharmonised_parquet_dir}{The path to a directory containing parquet
files, one for each dataset, e.g.
/vast/projects/cellxgene_curated/metadata_non_harmonised_parquet_0.2}

\item{...}{
  Arguments passed on to \code{\link[=upload_swift]{upload_swift}}
  \describe{
    \item{\code{source}}{A character scalar indicating the local path to the file to
upload}
    \item{\code{container}}{A character scalar indicating the name of the container to
upload to}
    \item{\code{name}}{An optional character scalar indicating the name the file should
have after being uploaded. Defaults to being the basename of the source
file.}
    \item{\code{credential_id}}{The OpenStack application credential secret as a
character scalar}
  }}
}
\value{
\code{NULL}, invisibly
}
\description{
Update the unharmonised parquet files
}
\examples{
\dontrun{
update_unharmonised(
    "/vast/projects/cellxgene_curated/metadata_non_harmonised_parquet_0.2", 
    credential_id = "ABCDEFGHIJK", 
    credential_secret = "ABCD1234EFGH-5678IJK"
)
}
}
\keyword{internal}
