% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/narrowAlignments.R
\name{narrowAlignments}
\alias{narrowAlignments}
\alias{narrowAlignments,GAlignments,GRanges-method}
\title{Narrow a set of aligned reads to a target region}
\usage{
narrowAlignments(alns, target, ...)

\S4method{narrowAlignments}{GAlignments,GRanges}(
  alns,
  target,
  ...,
  reverse.complement,
  minoverlap = NULL,
  verbose = FALSE,
  clipping.ops = c("S", "H"),
  match.ops = c("M", "X", "=")
)
}
\arguments{
\item{alns}{A GAlignments object including a metadata column "seq"
containing the sequence}

\item{target}{A GRanges object}

\item{...}{additional arguments}

\item{reverse.complement}{Should the aligned reads be reverse complemented?}

\item{minoverlap}{Minimum overlapping region between alignments and target.
If not specified, alignments must span the entire target region.
(Default: NULL)}

\item{verbose}{(Default: FALSE)}

\item{clipping.ops}{CIGAR operations corresponding to clipping
(Default: c("S","H"))}

\item{match.ops}{CIGAR operations corresponding to a match, i.e.
a non-indel position (Default: c("M","X","="))}
}
\value{
The narrowed alignments (GAlignments)
}
\description{
Aligned reads are narrowed to the target region.  In
the case of reads with deletions spanning the boundaries of the target,
reads are narrowed to the start of the deletion,
}
\examples{
bam_fname <- system.file("extdata", "gol_F1_clutch_2_embryo_4_s.bam",
                         package = "CrispRVariants")
bam <- GenomicAlignments::readGAlignments(bam_fname, use.names = TRUE)
target <- GenomicRanges::GRanges("18", IRanges::IRanges(4647377, 4647399),
          strand = "+")
narrowAlignments(bam, target, reverse.complement = FALSE)
}
\author{
Helen Lindsay
}
