% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dispatchDots}
\alias{dispatchDots}
\title{dispatchDots}
\usage{
dispatchDots(func, ..., call = FALSE)
}
\arguments{
\item{func}{Function to call}

\item{...}{dot args to pass to function}

\item{call}{If TRUE, call the function with the argument list and
return this result (Default: FALSE)}
}
\value{
A list of arguments to pass to func, or if call is TRUE, the result
of calling func with these arguments.
}
\description{
Update default values for func with values from dot args
}
\examples{
# Set up a function to dispatch dot arguments to:
f <- function(a=1, b=2, c=3){
 print(c(a,b,c))
}
# Set up a function for passing dots:
g <- function(...){
 CrispRVariants:::dispatchDots(f, ...)
}

g(a = 5)
g(a = 5, call = TRUE)
# Unrelated arguments will not be passed on
g(a = 5, d = 6)
}
\author{
Helen Lindsay
}
