% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-coerce.R
\name{as.long.table}
\alias{as.long.table}
\title{Coerce from data.table to LongTable}
\usage{
as.long.table(x)
}
\arguments{
\item{x}{A \code{data.frame} with the 'longTableDataMapper' attribute, containing
three lists named assayCols, rowDataCols and colDataCols. This attribute
is automatically created when coercing from a LongTable to a data.table.}
}
\value{
\code{LongTable} object configured with the longTableDataMapper
}
\description{
Coerce a data.table with the proper configuration attributes
back to a LongTable
}
\examples{
dataTable <- as(merckLongTable, 'data.table')
print(attr(dataTable, 'longTableDataMapper')) # Method doesn't work without this
as.long.table(dataTable)

}
