% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTableDataMapper-class.R,
%   R/LongTableDataMapper-accessors.R
\name{LongTableDataMapper-accessors}
\alias{LongTableDataMapper-accessors}
\alias{rawdata,LongTableDataMapper-method}
\alias{rawdata<-,LongTableDataMapper,list-method}
\alias{rowDataMap,LongTableDataMapper-method}
\alias{rowDataMap<-,LongTableDataMapper,list_OR_List-method}
\alias{rowDataMap<-,LongTableDataMapper,list-method}
\alias{rowDataMap<-LongTableDataMapper,List-method}
\alias{colDataMap,LongTableDataMapper-method}
\alias{colDataMap<-,LongTableDataMapper,list_OR_List-method}
\alias{colDataMap<-LongTableDataMapper,List-method}
\alias{assayMap,LongTableDataMapper-method}
\alias{assayMap,LongTableDataMapper,list-method}
\alias{assayMap,LongTableDataMapper,List-method}
\alias{assayMap<-,LongTableDataMapper,list_OR_List-method}
\alias{assayMap<-,LongTableDataMapper,list-method}
\alias{assayMap<-,LongTableDataMapper,List-methhod}
\alias{metadataMap,LongTableDataMapper-method}
\alias{metadataMap<-,LongTableDataMapper,list_OR_List-method}
\alias{metadataMap<-,LongTableDataMapper-method}
\title{Accessing and modifying data in a \code{LongTableDataMapper} object.}
\usage{
\S4method{rawdata}{LongTableDataMapper,list}(object) <- value

\S4method{rowDataMap}{LongTableDataMapper}(object)

\S4method{rowDataMap}{LongTableDataMapper,list_OR_List}(object) <- value

\S4method{colDataMap}{LongTableDataMapper}(object)

\S4method{colDataMap}{LongTableDataMapper,list_OR_List}(object) <- value

\S4method{assayMap}{LongTableDataMapper}(object)

\S4method{assayMap}{LongTableDataMapper,list_OR_List}(object) <- value

\S4method{metadataMap}{LongTableDataMapper}(object)

\S4method{metadataMap}{LongTableDataMapper,list_OR_List}(object) <- value
}
\arguments{
\item{object}{A \code{LongTableDataMapper} object to get or set data from.}

\item{value}{See details.}
}
\value{
Accessors: See details

Setters: An update \code{LongTableDataMapper} object, returned invisibly.
}
\description{
Documentation for the various setters and getters which allow manipulation
of data in the slots of a \code{LongTableDataMapper} object.
}
\details{
\strong{rawdata}: Get the raw data slot from a \code{LongTableDataMapper} object. Returns
a list-like containing one or more raw data inputs to the
\code{LongTableDataMapper} object.

\strong{rawdata}: Set the raw data slot from a \code{LongTableDataMapper} object.
\strong{value}: The \code{list}-like object to set for the rawdata slot. Note: this
currently only supports \code{data.frame} or \code{data.table} objects.

\strong{rowDataMap}: \code{list} of two \code{character} vectors, the first are the
columns required to uniquely identify each row of a \code{LongTableDataMapper} and the
second any additional row-level metadata. If the character vectors
have names, the resulting columns are automatically renamed to the
item name of the specified column.

\strong{rowDataMap<-}: Update the \verb{@rowDataMap} slot of a \code{LongTableDataMapper} object,
returning an invisible NULL. Arguments:
\itemize{
\item value: A \code{list} or \code{List} where the first item is the names of the
identifier columns -- columns needed to uniquely identify each row in
rowData -- and the second item is the metadata associated with those
the identifier columns, but not required to uniquely identify rows in
the object rowData.
}

\strong{colDataMap}: \code{list} of two \code{character} vectors, the first are the
columns required to uniquely identify each row of a \code{LongTableDataMapper} and the
second any additional col-level metadata. If the character vectors
have names, the resulting columns are automatically renamed to the
item name of the specified column.

\strong{colDataMap<-}: Update the \verb{@colDataMap} slot of a \code{LongTableDataMapper} object,
returning an invisible NULL. Arguments:
\itemize{
\item value: A \code{list} or \code{List} where the first item is the names of the
identifier columns -- columns needed to uniquely identify each row in
colData -- and the second item is the metadata associated with those
the identifier columns, but not required to uniquely identify rows in
the object rowData.
}

\strong{assayMap}:  A \code{list} of character vectors. The name of each list item
will be the assay in a \code{LongTableDataMapper} object that the columns in the
\code{character} vector will be assigned to. Column renaming occurs automatically
when the character vectors have names (from the value to the name).

\strong{assayMap<-}: Updates the \verb{@assayMap} slot of a \code{LongTableDataMapper} object,
returning an invisible NULL. Arguments:
\itemize{
\item value:  A \code{list} of character vectors, where the name of each list
item is the name of an assay and the values of each character vector
specify the columns mapping to the assay in the \code{S4} object the
\code{LongTableDataMapper} constructs.
}

\strong{metadataMap}:  A \code{list} of \code{character} vectors. Each item is an element
of the constructed objects \verb{@metadata} slot.

\strong{metadataMap<-}: Updates \code{LongTableDataMapper} object in-place, then returns an
\code{invisible(NULL)}. Arguments:
\itemize{
\item value:  A \code{list} of \code{character} vectors. The name of each list item
is the name of the item in the \verb{@metadata} slot of the \code{LongTableDataMapper} object
created when \code{metaConstruct} is called on the \code{DataMapper}, and a
character vector specifies the columns of \verb{@rawdata} to assign to each item.
}
}
\examples{
rowDataMap(exampleDataMapper)

rowDataMap(exampleDataMapper) <- list(c('treatmentid'), c())

colDataMap(exampleDataMapper)

colDataMap(exampleDataMapper) <- list(c('sampleid'), c())

assayMap(exampleDataMapper)

assayMap(exampleDataMapper) <- list(sensitivity=c(viability1='viability'))

metadataMap(exampleDataMapper)

metadataMap(exampleDataMapper) <- list(object_metadata=c('metadata'))

}
\seealso{
Other DataMapper-accessors: 
\code{\link{DataMapper-accessors}},
\code{\link{TREDataMapper-accessors}}
}
\concept{DataMapper-accessors}
