% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellStateMethods.R
\name{TabulateCellBinsByGroup}
\alias{TabulateCellBinsByGroup}
\alias{TabulateCellBinsByGroup.SingleCellExperiment}
\alias{TabulateCellBinsByGroup,SingleCellExperiment-method}
\title{Tabulate cell bins by group}
\usage{
TabulateCellBinsByGroup.SingleCellExperiment(object, group, relative, margin)

\S4method{TabulateCellBinsByGroup}{SingleCellExperiment}(object, group, relative = FALSE, margin = 1)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class obtained with the
function \code{BinCellClusterProbability()}.}

\item{group}{Character specifying the \code{colData} variable from the \code{SingleCellExperiment}
object provided to the function \code{BinCellClusterProbability()} to use as
categorical group variable.}

\item{relative}{Logical specifying if relative proportions of cell bins per
\code{group} should be returned. By default \code{FALSE}, i.e., absolute values
are returned.}

\item{margin}{If \code{relative} is \code{TRUE}, proportions should be calculated
by: rows (\code{1}, the default); columns (\code{2}); or overall (\code{NULL}).}
}
\value{
A list of tables with the frequency of cells per bin of cell cluster probability by group for each label.
}
\description{
Frequency of cells per cell cluster probability bin by group for each label.
The label has to be specified beforehand to the function \code{BinCellClusterProbability()}.
}
\examples{
\donttest{
# Packages
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Import data from Zenodo
data.url <- "https://zenodo.org/records/14845751/files/pbmc_10Xassays.rds?download=1"
sce <- readRDS(file = url(data.url))

# Prepare data
sce <- PrepareData(object = sce)

# Multi-level integration - 'L = 4' just for highlighting purposes
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "batch", L = 4,
    threads = 2
)

# Cell states SCE object for a given cell type annotation or clustering
cellstate.sce <- BinCellClusterProbability(
    object = sce, label = "cell_type",
    icp.round = 4, bins = 20
)
cellstate.sce

# Tabulate cell bins by group
# give an interesting variable to the "group" parameter
cellbins.tables <- TabulateCellBinsByGroup(
    object = cellstate.sce,
    group = "batch",
    relative = TRUE,
    margin = 1
)
}

}
\keyword{Table}
\keyword{bins}
\keyword{cell}
\keyword{group}
