% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{FindClusterMarkers}
\alias{FindClusterMarkers}
\alias{FindClusterMarkers.SingleCellExperiment}
\alias{FindClusterMarkers,SingleCellExperiment-method}
\title{Differential expression between cell clusters}
\usage{
FindClusterMarkers.SingleCellExperiment(
  object,
  clustering.label,
  clusters.1,
  clusters.2,
  test,
  log2fc.threshold,
  min.pct,
  min.diff.pct,
  min.cells.group,
  max.cells.per.cluster,
  return.thresh,
  only.pos
)

\S4method{FindClusterMarkers}{SingleCellExperiment}(
  object,
  clustering.label,
  clusters.1 = NULL,
  clusters.2 = NULL,
  test = "wilcox",
  log2fc.threshold = 0.25,
  min.pct = 0.1,
  min.diff.pct = NULL,
  min.cells.group = 3,
  max.cells.per.cluster = NULL,
  return.thresh = 0.01,
  only.pos = FALSE
)
}
\arguments{
\item{object}{A \code{SingleCellExperiment} object.}

\item{clustering.label}{A variable name (of class \code{character}) available
in the cell metadata \code{colData(object)} with the clustering labels
(\code{character} or \code{factor}) to use.}

\item{clusters.1}{a character or numeric vector denoting which clusters
to use in the first group (named group.1 in the results)}

\item{clusters.2}{a character or numeric vector denoting which clusters
to use in the second group (named group.2 in the results)}

\item{test}{Which test to use. Only "wilcoxon" (the Wilcoxon rank-sum test,
AKA Mann-Whitney U test) is supported at the moment.}

\item{log2fc.threshold}{Filters out features that have log2 fold-change of the
averaged feature expression values below this threshold.
Default is \code{0.25}.}

\item{min.pct}{Filters out features that have dropout rate (fraction of cells
expressing a feature) below this threshold in both comparison groups
Default is \code{0.1}.}

\item{min.diff.pct}{Filters out features that do not have this minimum
difference in the dropout rates (fraction of cells expressing a feature)
between the two comparison groups. Default is \code{NULL}.}

\item{min.cells.group}{The minimum number of cells in the two comparison
groups to perform the DE analysis. If the number of cells is below the
threshold, then the DE analysis is not performed.
Default is \code{3}.}

\item{max.cells.per.cluster}{The maximun number of cells per cluster
if downsampling is performed to speed up the DE analysis.
Default is \code{NULL}, i.e. no downsampling.}

\item{return.thresh}{If only.pos=TRUE, then return only features that
have the adjusted p-value (adjusted by the Bonferroni method) below or
equal to this threshold.  Default is \code{0.01}.}

\item{only.pos}{Whether to return only features that have an adjusted
p-value (adjusted by the Bonferroni method) below or equal to the
threshold. Default is \code{FALSE}.}
}
\value{
a data frame of the results if positive results were found, else NULL
}
\description{
\code{FindClusterMarkers} enables identifying feature markers for one
cluster or two arbitrary combinations of clusters, e.g. 1_2 vs. 3_4_5. Feature
and cell filters can be applied to accelerate the analysis, but this might
lead to missing weak signals.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Markers between versicolor vs virginica
dge <- FindClusterMarkers(sce,
    clustering.label = "Species",
    clusters.1 = "versicolor",
    clusters.2 = "virginica"
)
dge

}
\keyword{DE}
\keyword{analysis}
\keyword{differential}
\keyword{expression}
\keyword{feature}
\keyword{markers}
