% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsDNAcopy.R
\name{loadCopyNumberCallsDNAcopy}
\alias{loadCopyNumberCallsDNAcopy}
\title{loadCopyNumberCallsDNAcopy}
\usage{
loadCopyNumberCallsDNAcopy(DNAcopy.data, chr.col = "chrom", start.col = "loc.start", end.col = "loc.end", segment.value.col = "seg.mean", cn.col = NULL, chr.transformation = "23:X,24:Y,25:MT", genome = NULL, verbose = TRUE)
}
\arguments{
\item{DNAcopy.data}{The name of the file with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to "chrom")}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to "loc.start")}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to "loc.end")}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to "seg.mean")}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NULL)}

\item{chr.transformation}{(character) The transformation of the chromosome names in a comma separated "key:value" format.(defaults to "23:X,24:Y,25:MT")}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment or a list of GRanges with a GRanges per sample.
}
\description{
Loads copy number calls from DNACopy results.
}
\details{
This function will load segments data from DNAcopy data structure
in R. Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files.
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{

library(DNAcopy)

data(coriell)
CNA.object <- suppressWarnings(CNA(cbind(coriell$Coriell.05296), coriell$Chromosome, coriell$Position, data.type="logratio",sampleid="c05296"))

smoothed.CNA.object <- smooth.CNA(CNA.object)
DNAcopy.data <- segment(smoothed.CNA.object, verbose=1)

cnv.call <- loadCopyNumberCallsDNAcopy(DNAcopy.data = DNAcopy.data)

# more than 1 sample
CNA.object <- CNA(genomdat = cbind(coriell$Coriell.05296, coriell$Coriell.13330), chrom = coriell$Chromosome, maploc = coriell$Position, data.type = "logratio", sampleid = c("c05296", "c13330"))
smoothed.CNA.object <- smooth.CNA(CNA.object)
DNAcopy.data <- segment(smoothed.CNA.object, verbose=1)

cnv.call <- loadCopyNumberCallsDNAcopy(DNAcopy.data = DNAcopy.data)

}
