% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCompDbPackage.R
\name{compound_tbl_lipidblast}
\alias{compound_tbl_lipidblast}
\title{Extract compound data from LipidBlast}
\usage{
compound_tbl_lipidblast(
  file,
  collapse = character(),
  n = -1L,
  verbose = FALSE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{file}{\code{character(1)} with the name of the file name.}

\item{collapse}{optional \code{character(1)} to be used to collapse multiple
values in the columns \code{"synonyms"}. See examples for details.}

\item{n}{\code{integer(1)} defining the number of rows from the json file that
should be read and processed at a time. By default (\code{n = -1L}) the
complete file is imported and processed. For large json files it is
suggested to set e.g. \code{n = 100000} to enable chunk-wise processing and
hence reduce the memory demand.}

\item{verbose}{\code{logical(1)} whether some progress information should be
provided. Defaults to \code{verbose = FALSE}, but for parsing very large
files (specifically with chunk-wise processing enabled with \code{n} > 0)
it might be helpful to set to \code{verbose = TRUE}.}

\item{BPPARAM}{\code{BiocParallelParam} object to configure parallel processing.
Defaults to \code{bpparam()}.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with general compound information (one row per
compound):
\itemize{
\item \code{compound_id}: the ID of the compound.
\item \code{name}: the compound's name.
\item \code{inchi}: the InChI of the compound.
\item \code{inchikey}: the InChI key.
\item \code{smiles}: the SMILES representation of the compound.
\item \code{formula}: the chemical formula.
\item \code{exactmass}: the compound's mass.
\item \code{compound_class}: the class of the compound.
\item \code{ionization_mode}: the ionization mode.
\item \code{precursor_mz}: the precursor m/z value.
\item \code{precursor_type}: the precursor type.
\item \code{retention_time}: the retention time.
\item \code{ccs}: the collision cross-section.
\item \code{spectrum}: the spectrum data (i.e. the mass peaks, as a concatenated
character string).
\item \code{synonyms}: the compound's synonyms (aliases). This type of this column is
by default a \code{list} to support multiple aliases per compound, unless
argument \code{collapse} is provided, in which case multiple synonyms are pasted
into a single element separated by the value of \code{collapse}.
}
}
\description{
\code{compound_tbl_lipidblast()} extracts basic compound annotations from a
LipidBlast file in (json format) downloaded from
http://mona.fiehnlab.ucdavis.edu/downloads . Note that no mass spectra data
is extracted from the json file.
}
\examples{

## Read compound information from a subset of HMDB
fl <- system.file("json/MoNa-LipidBlast_sub.json", package = "CompoundDb")
cmps <- compound_tbl_lipidblast(fl, n = 50000, verbose = TRUE)
cmps
}
\seealso{
Other compound table creation functions: 
\code{\link{compound_tbl_sdf}()}
}
\author{
Johannes Rainer, Jan Stanstrup and Prateek Arora
}
\concept{compound table creation functions}
